#utilitaires pour theorie des graphes sur le metro parisien
#version inclusant Dijkstra
#coding='latin'
#importation des modules usuels
from tkinter import *
from time import *
from math import *

#initialisations et constantes
r = 6 #rayon des disques representant une station
n = 0 #nombre de stations
Couleurs=["White","Yellow","Blue","Grey","Purple","Orange","LightBlue","Pink","Grey","LightGrey","Brown","chocolate1","DarkGreen","Cyan","Black"]*20
#couleurs des lignes de metro dans leur ordre d'indexation
def RGBConvert(r,g,b) : #convertisseur de code RGB en code couleur
    rm, gm, bm = min(r,255),min(g,255),min(b,255)
    code = '#%02x%02x%02x' % (r, g, b)
    return(code)

#L est la liste des stations
#pour chaque station, les elements sont dans l'ordre :
#    nom (string),
#    code (string 4),
#    arrondissement (string),
#    lignes (list of int),
#    abscisse (int),
#    ordonnee (int),
#    successeurs (list of code) 

#initialisation graphique classique avec TKinter
Fen1 = Tk()
Plan = Canvas(Fen1, width=1020, height=720)
Plan.grid(column=0, row=0)
Fond = PhotoImage(file = 'Plan2.gif')
Plan.create_image(0,0,image=Fond,anchor=NW)
Plan.update()
Plan.create_rectangle(700,5,980,35,fill="White")
Info = Plan.create_text(715,20,text='Nom',font='Arial 15', anchor=W)

#initialisation de la liste de stations
index = 0
V = []

def ClicStation(event) : #detecte la station sur laquelle on a clique sur le graphe Plan
    global V
    x = int(event.x) #lecture de l'evenement
    y = int(event.y)
    LaStation, Trouve = None, False
    for station in L : #exploration de la liste des stations
        xs, ys = station[4], station[5] #coordonnees de la station
        if abs(xs-x)<=r and abs(ys-y) <= r : #proximite avec les coordonnees lues
            LaStation = station
            Trouve = True
    if Trouve : #on ne fait pas que retourner, on affiche
        Plan.itemconfig(Info,text=LaStation[1]+'*'+LaStation[0])
        V.append(LaStation[1])
    else :
        Plan.itemconfig(Info,text="Essaye encore")
    return(LaStation)

Plan.bind("<Button-1>", ClicStation)


#lecture du fichier attention a lencoding (ici latin-1)
Fic = open('RATP_voisins.txt','r',encoding='latin-1')
L, Dico, Codi, Carres = [], {}, {}, []
#L est la liste des stations
#Carres est la liste des objets Tkinter "carres pour localiser la station"
#initialement, ils sont transparents
for ligne in Fic : #on va lire ligne par ligne le fichier texte et en faire des nombres, listes...
    Nom, Code, MotLignes, Arrondissement, Motx, Moty = "", "", "", "", "", ""
    i = 0
    while ligne[i] != ";" :
        Nom += ligne[i]
        i+=1
    i+=1
    while ligne[i] != ";" :
        Code += ligne[i]
        i+=1
    i+=1
    while ligne[i] != ";" :
        MotLignes += ligne[i]
        i+=1
    Lignes = []
    for nl in MotLignes.split(',') :
        Lignes.append(int(nl))
    i+=1
    while ligne[i] != ";" :
        Arrondissement += ligne[i]
        i+=1
    i+=1
    while ligne[i] != ";" :
        Motx += ligne[i]
        i+=1
    x = int(Motx)
    i+=1
    while ligne[i] != ";" :
        Moty += ligne[i]
        i+=1
    y = int(Moty)
    motfin = ligne[i+2:-2].split(',')
    suivants = []
    for st in motfin :
        suivants.append(st[1:-1])
    Plan.itemconfig(Info,text=Nom)
    Carres.append(Plan.create_rectangle(x-10,y-10,x+10,y+10,fill=None,width=0))
    
        
    Plan.update()
    #sleep(0.01)
    if "Paris" in Arrondissement : #on ne garde que les stations intra-muros
        L.append([Nom, Code, Arrondissement, Lignes, x, y, suivants])
        Dico[Code]=n
        Codi[n]=Code
        Plan.create_oval(x-r,y-r,x+r,y+r,fill="Orange",width=2)
        n += 1
Fic.close()



def VisuMatrice(M,echx=3,echy=2,nom="Matrice") :
    #ouvre une fenetre pour afficher la matrice (carree) du graphe
    #en cliquant on recupere le nom des deux stations et la valeur du terme de la matrice
    N = len(M)
    FVM = Tk()
    FVM.title(nom)
    CVM = Canvas(FVM, width=echx*(N+2),height=echy*(N+2))
    CVM.grid(row=1,column=1)
    TVM = Label(FVM,text="Cliquez sur une case pour connaitres les stations concernees")
    TVM.grid(row=2,column=1)
    CVM.create_rectangle(echx,echy,echx*(N+2),echy*(N+2),width=echx//2,fill=None)
    def Clic(event) :
        #recuperation des coordonnees du point de clic et affichage des infos
        x,y = int(event.x),int(event.y)
        i, k = y//echy-1,x//echx-1
        depart, arrivee = L[k][0], L[i][0]
        TVM.configure(text=depart+','+arrivee+' : '+str(M[i][k]))
    #affichage des valeurs sous forme de niveau de bleu
    for k in range(N) :
        for i in range(N) :
            x, y, Index = (k+1)*echx, (i+1)*echy, k*N+i
            if M[i][k] > 0 :
                CVM.create_rectangle(x,y,x+echx,y+echy,width=0,fill=RGBConvert(0,0,M[i][k]+50))
    #associaition du clic de sousris a l'action lecture
    CVM.bind("<Button-1>", Clic)
    FVM.update()            
    #FVM.mainloop()


def PointeStation(k, couleur= "Black") :#met en valeur la station k sur Plan ; couleur par defaut "noir"
    #k peut etre un entier ou un code
    index = -1
    if type(k)==int :
        index = k
    if type(k)==str and k in Dico.keys() :
        index = Dico[k]
    if -1<index<n : 
        Plan.itemconfig(Carres[index],fill=couleur)
    else :
        print("Quelle station demandez vous ?")


#creation de la liste des poids des arêtes
def dist(i,j) : #distance euclidienne entre deux stations
    xi, yi, xj, yj =L[i][4], L[i][5],L[j][4],L[j][5]
    dis = int(sqrt((xi-xj)**2+(yi-yj)**2))
    return(dis)

LA = [[float("inf") for k in range(n)] for i in range(n)]
for i in range(n) :
    Dep = L[i]
    xd, yd = Dep[4], Dep[5]
    for Voisin in Dep[6] :
        if Voisin in Dico :
            k = Dico[Voisin]
            Arr = L[Dico[Voisin]]
            xa, ya = Arr[4], Arr[5]
            Dist = int(sqrt((xd-xa)**2+(yd-ya)**2))
            if LA[k][i] == float("inf") :
                Plan.create_text((xd+xa)/2,(yd+ya)/2,text=str(Dist),fill="DarkBlue")
            LA[i][k] = Dist
Plan.update()


def Dijkstra(Si, Sc) : #int, int -> lists
    Gris = [Si] #seul le sommet initial est gris
    Blanc = [True]*n #tous les sommets sont blancs
    Blanc[Si] = False #sauf le sommet initial
    Noir = [False]*n #aucun sommet n'est noir
    #on pourrait plutôt créer un dictionnaire de couleur de chaque sommet !
    d = [float("inf")]*n #tous sont pour l'instant à distance infinie de Si
    d[Si] = 0 #sauf Si quand même
    Pere = [None]*n #personne n'a de père, même Si (à la fin, il n'en aura toujours pas)
    while Gris : #tant qu'il y a des sommets gris
        #recherche dans la liste grise de l'élément de priorité minimale
        Mini = float("inf") #un minimum à "dépasser"
        S = 0 #un index qui sera remplacé
        for i in Gris : #on regarde parmi tous les gris
            if d[i] < Mini : #si il est plus proche de l'origine que le précédent record
                Mini = d[i] #c'est lui le nouveau record
                S = i #on mémorise son index
        #S est l'index du sommet de priorité minimale
        Gris.remove(S)
        print(S,Gris)
        Noir[S] = True #on le met en noir
        if S == Sc : #si c'est le sommet de destination
            break #on a gagné
        for Voisin in L[S][6] : #on prend la liste des voisins de ce sommet (attention, ce sont des codes de quatre lettres)
            if Voisin in Dico : #attention aux stations qui ne seraient pas dans Paris, elles sont encore dans la liste des Voisins
                Sprime = Dico[Voisin] #on veut un index et pas un code : dictionnaire SVP
                if Sprime in Gris : #si il est dans gris
                    if d[S]+LA[S][Sprime] < d[Sprime] :
                        d[Sprime] = d[S]+LA[S][Sprime]
                        Pere[Sprime] = S
                if Blanc[Sprime] : #si il est blanc
                    Blanc[Sprime] = False #il n'est plus blanc
                    Gris.append(Sprime) #on le colorie en gris 
                    d[Sprime] = d[S]+LA[S][Sprime] #avec priorité calculée
                    Pere[Sprime] = S #on lui donne un père
                
        
    #disons qu'on est sorti favorablement
    Total = d[Sc] #quelle est la distance entre Si et Sc
    Trajet = [L[Sc][0]]
    if Total != float('inf') :
        ancetre = Sc
        while ancetre != Si :
            ancetre = Pere[ancetre]
            Trajet = [L[ancetre][0]]+Trajet
    return(Total,Trajet)
#on teste de Saint-Paul à Botzaris
print(Dijkstra(Dico['paul'],Dico['botz']))

Fen1.mainloop()
